(function () {
  function getUrl(params){
    if(!params.domain){
      console.error("请求参数缺少domain");
      return ""
    }
    let url = params.domain;
    if(params.pathName){
      url+=`/${params.pathName}`
    }
    console.log("url",url)
    return url;
  }
  function ajaxForGet(url, data, async, params, cb, failcb){
    $.ajax({
      url: getUrl(params) + url,
      async: async,
      type: 'GET',
      beforeSend: function (request) {
        request.setRequestHeader('Authorization', params.accessToken);
        request.setRequestHeader('Access', 'Client');
      },
      data: data,
      dataType: 'json'
    })
    .done(function (result) {
      cb(result);
    })
    .fail(function (error) {
      if(failcb){
        failcb(error)
      }
      console.log(error);
    });
  }
  function ajaxForGetBear(url, data, async, params, cb, failcb){
    $.ajax({
      url: getUrl(params) + url,
      async: async,
      type: 'GET',
      data: data,
      dataType: 'json',
      beforeSend: function (request) {
        request.setRequestHeader('Authorization', 'Bearer ' + params.accessToken);
        request.setRequestHeader('Access', 'Client');
      },
    })
    .done(function (result) {
      cb(result);
    })
    .fail(function (error) {
      console.log(error);
      if(failcb){
        failcb(error)
      }else{
        console.log(error);
      }
    });
  }
  function ajaxForPost(url, data, async, params, cb, failcb){
    $.ajax({
      url: getUrl(params) + url,
      async: async,
      data: data,
      beforeSend: function (request) {
        request.setRequestHeader('Authorization', params.accessToken);
        request.setRequestHeader('Access', 'Client');
      },
      dataType: 'json',
      type: 'POST'
    })
    .done(function (result) {
      cb(result);
    })
    .fail(function (error) {
      failcb(error);
    });
  }
  let ajax = {
    getAlphaAttrGroupByValue: function (params, cb, failcb) {
      let url = '/api/label/getAlphaAttrGroupByValue'
      let data = {
        platformId: params.platformId
      }
      let async = true
      ajaxForGet(url, data, async, params, cb, failcb)
    },
    getAlphaAttrGroup: function (params, cb, failcb) {
      let url = '/api/label/getAlphaAttrGroup';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getAlphaAttrGroupByThemeId: function (params, cb, failcb) {
      let url = '/api/label/getAlphaAttrGroupByThemeId';
      let data = {
        themeId: params.themeId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getAlphaAttrGroupByVersionId: function (params, cb, failcb) {
      let url = '/api/label/getAlphaAttrGroupByVersionId';
      let data = {
        versionId: params.versionId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getColrAttrGroupByValue: function (params, cb, failcb) {
      let url = '/api/label/getColrAttrGroupByValue';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getColorAttrGroup: function (params, cb, failcb) {
      let url = '/api/label/getColorAttrGroup';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getColorAttrGroupByThemeId: function (params, cb, failcb) {
      let url = '/api/label/getColorAttrGroupByThemeId';
      let data = {
        themeId: params.themeId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getColorAttrGroupByVersionId: function (params, cb, failcb) {
      let url = '/api/label/getColorAttrGroupByVersionId';
      let data = {
        versionId: params.versionId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getRadiusAttrGroupByValue: function (params, cb, failcb) {
      let url = '/api/label/getRadiusAttrGroupByValue';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getRadiusAttrGroup: function (params, cb, failcb) {
      let url = '/api/label/getRadiusAttrGroup';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getRadiusAttrGroupByThemeId: function (params, cb, failcb) {
      let url = '/api/label/getRadiusAttrGroupByThemeId';
      let data = {
        themeId: params.themeId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getSpacingAttrGroupByValue: function (params, cb, failcb) {
      let url = '/api/label/getSpacingAttrGroupByValue';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getSpacingAttrGroup: function (params, cb, failcb) {
      let url = '/api/label/getSpacingAttrGroup';
      let data = {
        platformId: params.platformId
      };
      let async = false;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getSpacingAttrGroupByThemeId: function (params, cb, failcb) {
      let url = '/api/label/getSpacingAttrGroupByThemeId';
      let data = {
        themeId: params.themeId
      };
      let async = false;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontSizeAttrGroupByValue: function (params, cb, failcb) {
      let url = '/api/label/getFontSizeAttrGroupByValue';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontSizeAttrGroup: function (params, cb, failcb) {
      let url = '/api/label/getFontSizeAttrGroup';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontSizeAttrGroupByThemeId: function (params, cb, failcb) {
      let url = '/api/label/getFontSizeAttrGroupByThemeId';
      let data = {
        themeId: params.themeId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontFamilyAttrGroupByValue: function (params, cb, failcb) {
      let url = '/api/label/getFontFamilyAttrGroupByValue';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontFamilyAttrGroup: function (params, cb, failcb) {
      let url = '/api/label/getFontFamilyAttrGroup';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontFamilyAttrGroupByThemeId: function (params, cb, failcb) {
      let url = '/api/label/getFontFamilyAttrGroupByThemeId';
      let data = {
        themeId: params.themeId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontSpacingAttrGroupByValue: function (params, cb, failcb) {
      let url = '/api/label/getFontSpacingAttrGroupByValue';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontSpacingAttrGroup: function (params, cb, failcb) {
      let url = '/api/label/getFontSpacingAttrGroup';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getFontSpacingAttrGroupByThemeId: function (params, cb, failcb) {
      let url = '/api/label/getFontSpacingAttrGroupByThemeId';
      let data = {
        themeId: params.themeId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getAllMoudle: function (params, cb, failcb) {
      let url = '/module/findAll';
      let data = {
        platformId: params.platformId,
        roleId: 6
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getDeviceByUser: function (params, cb, failcb) {
      let url = '/platformDevice/findAll';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getVersionByUser: function (params, cb, failcb) {
      let url = '/platformVersion/findAll';
      let data = {
        platformId: params.platformId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    // 获取所有的版本、主题、终端
    getAllVersion: function (params, cb, failcb) {
      let url = '/api/version/getDeviceVersion';
      let data = {
        platformId: params.platformId
      };
      let async = false;
      ajaxForPost(url, data, async, params, cb, failcb);
    },
    // 获取登录信息
    getLoginUserInfo: function (params, cb, failcb) {
      let url = '/auth/getLoginUserInfo';
      let data = {};
      let async = true;
      ajaxForGetBear(url, data, async, params, cb, failcb);
    },
    // 获取模块项目信息
    getSimpleProjectInfo: function (params, cb, failcb) {
      let url = '/project/getSimpleProjectInfo';
      let data = {
        moduleId: params.moduleId,
        platformDeviceId: params.platformDeviceId,
        platformVersionId: params.platformVersionId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    // 获取模块项目信息
    getProjectDetails: function (params, cb, failcb) {
      let url = '/project/getProjectDetails';
      let data = {
        id: params.projectId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    // 获取模块项目信息
    getNewestSourceUpdateLog: function (params, cb, failcb) {
      let url = '/sourceUpdateLog/getNewestSourceUpdateLog';
      let data = {
        platformVersionId: params.libraryId
      };
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    logout: function (params, cb, failcb) {
      let url = '/auth/logout';
      let data = {};
      let async = true;
      ajaxForGet(url, data, async, params, cb, failcb);
    },
    getVersionInfoById: function (params, cb, failcb) {
      let url = '/api/version/getVersionInfoById';
      let data = {
        versionId: params.versionId
      };
      let async = true;
      ajaxForGetBear(url, data, async, params, cb, failcb);
    }
  };
  window.ajax = ajax;
})();
